@extends('layouts.app')
@section('Title', 'Author Marketing Promotion Services - Book Writing Cube')
@section('Description', 'Looking for a comprehensive author marketing service? Book Writing Cube offers a wide range of services to help you promote your work and connect with new readers.')
@section('metas')

<meta name="tags" content="en" />
<meta name="DC.title" content="ghost writing company" />
<meta name="geo.region" content="GB" />
<meta name="geo.position" content="55.753005;-2.857642" />
<meta name="ICBM" content="55.753005, -2.857642" />
<meta name="geo.region" content="US" />
<meta name="geo.position" content="39.78373;-100.445882" />
<meta name="ICBM" content="39.78373, -100.445882" />
<meta property="og:title" content="@yield('Title')" />
<meta property="og:description" content="Looking for a comprehensive author marketing service? Book Writing Cube offers a wide range of services to help you promote your work and connect with new readers." />
<meta property="og:url" content="https://www.bookwritingcube.us" />
<meta property="og:site_name" content="Book Writing Cube" />

@endsection



@include('layouts.navigation')

<section class="mb-0 pb-0 pt-4 cover author-marketing-promotion">
    <div class="container-fluid ">
        <div class="row">
            <div class="col-md-7 ">
                <span class="font-secondary fw-900 text-left font-50 font-50rem text-blue fm-30 ">
                    Capitalize On Your Visibility and Online Presence with Finest </span>
                <span>
                    <h1 class="font-secondary fw-900 text-left font-50 font-50rem text-blue fm-30 inline extracolor">Author
                        Marketing Promotion Services</h1>
                </span>
                <h3 class="text-left text-black font-18 fw-500 pb-3 pt-2 line-height-15 mp">
                    Reach a broader audience with <span>
                        <h2 class="text-left text-black font-18 fw-500 pb-3 pt-2 line-height-15 mp inline extracolor">
                            author marketing promotion services</h2>
                    </span>. Our author book marketing services guarantee you an improved reputation and sales.
                </h3>
                <div class="pb-3 pt-1">
                    <a href="javascript:void(Tawk_API.toggle())" class="btn btn-secondary"
                        id="btn2">LET'S
                        DISCUSS</a>
                    <a href="tel:866-600-0036" class="btn btn-secondary2 "> 866-600-0036</a>
                </div>
                <!-- For Mobile -->
                <div class="row pt-4 d-block d-lg-none d-md-none d-sm-block">
                    <div class="col-md-12 pb-5 d-flex justify-content-center align-items-center">
                        <div>
                            <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/bc20d1f9-01f6-44e4-ae57-cd1592c5f600/public"
                                    width="120"></a>
                        </div>
                        <div>
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/a550be31-f3cc-4b8d-1dd0-66777c4de000/public"
                                    width="160"></a>
                        </div>
                        <div>
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/6ead1ecf-f3c3-4ea1-9f60-ab7772924f00/public"
                                    width="120"></a>
                        </div>
                    </div>
                </div>
                <!-- For Mobile -->
                <div class="row pt-4 pr-5 d-none d-lg-block d-md-block d-sm-none">
                    <div class="col-md-12 pb-5">
                        <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/4657d808-ddb8-4b7e-621b-a9f432ad4800/public"
                                width="877" height="27"></a>
                    </div>
                </div>
                <div class="d-none d-lg-block d-md-block d-sm-none pb-5">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/bc20d1f9-01f6-44e4-ae57-cd1592c5f600/public"
                                    width="239" height="50"></a>
                        </div>
                        <div class="col-md-3">
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/a550be31-f3cc-4b8d-1dd0-66777c4de000/public"
                                    width="203" height="50"></a>
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <a href="https://www.bbb.org/us/or/beaverton/profile/publishers-book/book-writing-cube-1296-1000120771/#sealclick"
                                target="_blank" rel="nofollow noreferrer">
                                <img class="img-fluid  pl-3"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/65f9c8d0-35f9-48f4-21ba-351b4b859600/public"
                                    alt="Book Writing Cube BBB Business Review">
                            </a>
                        </div>
                        <div class="col-md-3">
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/6ead1ecf-f3c3-4ea1-9f60-ab7772924f00/public"
                                    width="146" height="50"></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-5"></div>
        </div>
    </div>
</section>

<x-logo-sliders />
<x-form-c-t-a />

<x-portfoliocaro/>

<section class="question-banner cover pb-5 pt-5">
    <div class="container-fluid">
        <div class="row justify-content-center text-center">
            <div class="col-md-10">
                <h3 class="text-capitalize text-center text-blue font-50 font-50rem fw-900 pb-2 pt-3 fm-30">
                    Combining The Elements of <span>
                        <h2
                            class="text-capitalize text-center text-blue font-50 font-50rem fw-900 pb-2 pt-3 fm-30 inline extracolor">
                            Author Marketing</h2>
                    </span> and Public Relations
                </h3>
                <h2 class="text-black font-16 fw-500 mp">
                    In general, the purpose of the author is to entertain the readers with the story, inform them of
                    reality, and persuade them of the truth. But with digital marketing on the rise, this purpose
                    has an additional aspect—to market themselves for readership. The author's skill is reflected in
                    the narrative and style they write in, but their readership is built when they are marketed
                    well. With Book Writing Cube's author promotion services, we create captivation ads for authors.
                    Whether they are Facebook ads for authors or Amazon ads for authors, we deliver!

                </h2>
            </div>
        </div>
        <div class="row justfy-content-center pt-5 pl-3 pr-3">
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-white">
                        <h5 class="card-title fw-800 text-black">
                            What is author marketing?
                        </h5>
                        <p class="card-text pb-4 text-black">
                            Author marketing is the process of promoting and selling books or other written works by
                            an author. This can include activities such as arranging book signings, conducting media
                            interviews, or organizing promotional events.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-black">
                        <h5 class="card-title fw-800 text-black">
                            What are some common author marketing strategies?
                        </h5>
                        <p class="card-text pb-4 text-black addReadMore showlesscontent">
                            There are many different ways to market a book or author, but some common strategies
                            include using social media, running ads in print or online publications, and partnering
                            with bookstores or libraries for promotional events.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justfy-content-center pt-5 pl-3 pr-3">
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3 text-black">
                        <h5 class="card-title fw-800 text-black">
                            How can author marketing services help me sell more books?
                        </h5>
                        <p class="card-text pb-4 text-black">
                            Author marketing services can provide valuable assistance with tasks such as creating a
                            media list, developing a publicity plan, or crafting press releases. These services can
                            help to increase exposure for your book and make it more likely to sell.
                    </div>
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-black">
                        <h5 class="card-title fw-800">
                            What are some things I should avoid when marketing my book?
                        </h5>
                        <p class="card-text pb-0">
                            There are a few things to avoid when marketing a book, such as spamming potential
                            customers or over-hyping your book. It's also important to remember that not everyone
                            will be interested in your book, so don't take rejections personally. Instead, focus on
                            finding the readers who will appreciate your work. Book Writing Cube's team of author
                            marketing experts creates engaging ads for authors and helps expand their reach.
                        </p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<x-logo-sliders/>
<section class="bg-blu">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-10 p-0">
                <h2 class="font-50 font-50rem text-center text-blue fw-900 fm-30">
                    Why Our <span class='extraColor'> Author Marketing Services</span> Are Ideal For You
                </h2>
            </div>
        </div>
        <div class="row pt-5 justify-content-center">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">1</div>
                    <div class="pl-md-4 pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Industry Experts </h3>
                        <p class="pr-md-5">
                            We have a team of experienced professionals who know how to promote your book.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">2</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Range of Services</h3>
                        <p class="pr-md-5">
                            We have a variety of services to choose from, so you can find the perfect package for
                            your needs.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row pt-md-5 pt-0">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">3</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Cost-Effective</h3>
                        <p class="pr-md-5">
                            We offer great value for money, with prices that are competitive and affordable.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">4</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Stellar Portfolio</h3>
                        <p class="pr-md-5">
                            We have a track record of success, with many clients achieving bestseller status.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row pt-md-5 pt-0">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">5</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Passion & Dedication </h3>
                        <p class="pr-md-5">
                            We are passionate about helping authors reach their goals and achieve success.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">6</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">24/7 Customer Service</h3>
                        <p class="pr-md-5">
                            Our team is dedicated to providing excellent customer service and support every step of
                            the way.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class=" d-none d-lg-block d-md-block d-sm-none">
    <div class="container-fluid">
        <div class="row text-center justify-content-center">
            <div class="col-md-10 pb-3">
                <h2 class="font-50 text-blue font-50rem fw-900 fm-30">
                    Our Efficient <span class='extraColor'> Author Marketing Process</span>
                </h2>
                <p class="text-black font-16 fw-500 mp text-center">
                    The Book Writing Cube's 5-step author marketing process is designed to help authors connect with
                    their audience, build a platform, and sell more books.
                </p>
            </div>
        </div>
        <div class="row justify-content-center ">
            <img src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/e23e5dae-e23e-4dd0-a265-4ef6a16f9200/public"
                width="1140" height="547" class="img-fluid" alt="book_writing_cube">
        </div>
    </div>
</section>

<x-contact-form-bottom
    title="Create the right buzz for every title you pen down with our<span class='extraColor'> Author Marketing</span> Promotion Services!" :
    description='From amateur author to a brilliant success story, our author marketing services transform your
name into a recognized brand.' />

<x-footer />