@extends('layouts.app')
@section('Title', 'Professional Book Promotion Services – Book Writing Cube')
@section('Description',
    'Book Promotion Services to make a noise around your books. Call our marketing gurus and let
    them make your book the talk of the town. ')
@section('metas')

    <meta name="tags" content="en" />
    <meta name="DC.title" content="ghost writing company" />
    <meta name="geo.region" content="GB" />
    <meta name="geo.position" content="55.753005;-2.857642" />
    <meta name="ICBM" content="55.753005, -2.857642" />
    <meta name="geo.region" content="US" />
    <meta name="geo.position" content="39.78373;-100.445882" />
    <meta name="ICBM" content="39.78373, -100.445882" />
    <meta property="og:title" content="@yield('Title')" />
    <meta property="og:description"
        content="Book Promotion Services to make a noise around your books. Call our marketing gurus and let them make your book the talk of the town. " />
    <meta property="og:url" content="https://www.bookwritingcube.us/book-promotion-services/" />
    <meta property="og:site_name" content="Book Writing Cube" />

@endsection



@include('layouts.navigation')

<section class="mb-0 pb-0 pt-4 cover book-promotion-service">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-7 ">
                <h1 class="font-secondary fw-900 text-left font-50 font-50rem text-blue fm-30 ">
                    Book <span class="extraColor">Promotion Services</span> That Give Your Book The Exposure It
                    Deserves!
                </h1>
                <h2
                    class="text-left text-black font-18 fw-500 pb-3 pt-2 line-height-15 mp addReadMore showlesscontent
                        ">
                    At Book Writing Cube, we offer comprehensive book marketing services tailored to enhance visibility,
                    drive sales, and expand your readership. Our expert strategies ensure your book reaches the right
                    audience, helping you establish a strong presence and reputation in the industry. Partner with us to
                    elevate your author brand and achieve lasting success.
                </h2>

                <div class="pb-3 pt-1">
                    <a href="javascript:void(Tawk_API.toggle())" class="btn btn-secondary" id="btn2">LET'S
                        DISCUSS</a>
                    <a href="tel:866-600-0036" class="btn btn-secondary2 "> 866-600-0036</a>
                </div>
                <!-- For Mobile -->
                <div class="row pt-4 d-block d-lg-none d-md-none d-sm-block">
                    <div class="col-md-12 pb-5 d-flex justify-content-center align-items-center">
                        <div>
                            <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/bc20d1f9-01f6-44e4-ae57-cd1592c5f600/public"
                                    width="120"></a>
                        </div>
                        <div>
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/a550be31-f3cc-4b8d-1dd0-66777c4de000/public"
                                    width="160"></a>
                        </div>
                        <div>
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/6ead1ecf-f3c3-4ea1-9f60-ab7772924f00/public"
                                    width="120"></a>
                        </div>
                    </div>
                </div>
                <!-- For Mobile -->
                <div class="row pt-4 pr-5 d-none d-lg-block d-md-block d-sm-none">
                    <div class="col-md-12 pb-5">
                        <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/4657d808-ddb8-4b7e-621b-a9f432ad4800/public"
                                width="877" height="27"></a>
                    </div>
                </div>
                <div class="d-none d-lg-block d-md-block d-sm-none pb-5">
                    <div class="row align-items-center">
                        <div class="col-lg-3 col-md-3">
                            <a href="#"> <img class="img-fluid" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/bc20d1f9-01f6-44e4-ae57-cd1592c5f600/public"></a>
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/a550be31-f3cc-4b8d-1dd0-66777c4de000/public"></a>
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <a href="https://www.bbb.org/us/or/beaverton/profile/publishers-book/book-writing-cube-1296-1000120771/#sealclick"
                                target="_blank" rel="nofollow noreferrer">
                                <img class="img-fluid  pl-3"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/65f9c8d0-35f9-48f4-21ba-351b4b859600/public"
                                    alt="Book Writing Cube BBB Business Review">
                            </a>
                        </div>
                        <div class="col-lg-3 col-md-3">
                            <a href="#"> <img class="img-fluid  pl-4" alt="book_writing_cube"
                                    src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/6ead1ecf-f3c3-4ea1-9f60-ab7772924f00/public"></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-5"></div>
        </div>
    </div>
</section>

<x-logo-sliders />

<x-form-c-t-a />



<x-portfoliocaro />

<section class="question-banner cover pb-5 pt-5">
    <div class="container-fluid">
        <div class="row justify-content-center text-center">
            <div class="col-md-10">
                <h2 class="text-capitalize text-center text-blue font-50 font-50rem fw-900 pb-2 pt-3 fm-30">
                    Simplify the Process of Selling Your Manuscript with Our <span class="extraColor">Expert Book
                        Marketing Services!</span>
                </h2>
                <h2 class="text-black font-16 fw-500 mp">

                    Book Writing Cube is a creative studio offering tailored book promotion services, including book
                    trailers, social media marketing, and more, to help authors and businesses reach a wider audience.
                    Below are some FAQs to help you learn more about our services.
                </h2>
            </div>
            <br><br>
        </div>
        <div class="row justfy-content-center pt-5 pl-3 pr-3">
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-white">
                        <h5 class="card-title fw-800 text-black">
                            Why Do I Need Book Promotion Services?
                        </h5>
                        <p class="card-text pb-4 text-black">
                            There are a lot of reasons why you might need book promotion services. Perhaps you're
                            self-publishing and want to make sure your book gets seen by as many people as possible.
                            Or maybe you've got a traditional publisher, but they're not doing much to promote your
                            book. In either case, working with a book promotion company can help you get your book
                            in front of more readers.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-black">
                        <h5 class="card-title fw-800 text-black">
                            What Kind of Services Do Book Promotion Companies Offer?
                        </h5>
                        <p class="card-text pb-4 text-black">
                            Book promotion companies offer a wide range of services, from helping you create a
                            social media campaign to organizing a book tour. They can also provide more general
                            marketing and publicity assistance, such as drafting press releases, working with book
                            reviewers, or kindle book promotion services for authors.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justfy-content-center pt-5 pl-3 pr-3">
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3 text-black">
                        <h5 class="card-title fw-800 text-black">
                            How Much Do Book Promotion Services Cost?
                        </h5>
                        <p class="card-text pb-4 text-black">
                            The cost of book promotion services varies depending on the company you work with and
                            the scope of the project. In general, you can expect to pay several hundred dollars for
                            basic services and upwards of a few thousand for more comprehensive campaigns.
                    </div>
                </div>
            </div>
            <div class="col-md-6 d-flex align-items-stretch mb-4">
                <div class="d-flex">
                    <div class="cardimg">
                        <img width="50" height="20" class="img-fluid" alt="book_writing_cube"
                            src="{{ asset('/assets/Question.svg') }}">
                    </div>
                    <div class="cardcontent pl-3  text-black">
                        <h5 class="card-title fw-800">
                            How Does Book Promotion Help Businesses?
                        </h5>
                        <p class="card-text pb-4 addReadMore showlesscontent">
                            Book promotion offers businesses a powerful way to increase brand awareness, drive sales,
                            and engage with targeted audiences. Through strategies like online ads, social media
                            campaigns, and events, it can effectively generate interest, boost visibility, and
                            strengthen brand recognition. When executed well, book promotion becomes an invaluable
                            marketing tool for businesses of all sizes, helping them grow and thrive.
                        </p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<x-logo-sliders />

<section class="bg-blu">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-10 p-0">
                <h2 class="font-50 font-50rem text-center text-blue fw-900 fm-30">
                    <span class="extraColor">Still Unsure?</span> Here Are the Reasons to Choose Us!
                </h2>
            </div>
        </div>
        <div class="row pt-5 justify-content-center">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num extraColor">1</div>
                    <div class="pl-md-4 pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Proven Track Record </h3>
                        <p class="pr-md-5">
                            Our company has a proven track record of successful book promotion campaigns.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">2</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Team of Marketing Gurus</h3>
                        <p class="pr-md-5">
                            Book Writing Cube offers tailored book promotion services with strategies designed to reach
                            your specific audience, ensuring effective engagement and maximum impact.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row pt-md-5 pt-0">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num">3</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Cost-Effective Solutions</h3>
                        <p class="pr-md-5">
                            We offer cost-effective book promotion services for authors that fit any budget. The
                            packages we offer regarding book marketing services include social media platforms,
                            blogging, guest posting, and email marketing.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num extraColor">4</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Extensive Network</h3>
                        <p class="pr-md-5">
                            We bear a wide range of contacts and resources to promote your book effectively. We've
                            helped authors from all genres and backgrounds achieve their publishing goals, and we
                            can do the same for you.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row pt-md-5 pt-0">
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num extraColor">5</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Deep Understanding </h3>
                        <p class="pr-md-5">
                            We have a deep understanding of the book promotion process and know how to get results.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="d-flex pl-md-5 pl-3">
                    <div class="article-num ">6</div>
                    <div class="pl-2 pt-3">
                        <h3 class="title font-20 fw-900 text-blue">Result-driven Approach </h3>
                        <p class="pr-md-5">
                            We are committed to providing the best possible online book promotion services and
                            achieving the desired results for our clients.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<x-blockcta />

<section class=" d-none d-lg-block d-md-block d-sm-none">
    <div class="container-fluid">
        <div class="row text-center justify-content-center">
            <div class="col-md-10 pb-3">
                <h2 class="font-50 text-blue font-50rem fw-900 fm-30">
                    Here’s How We Accelerate Your Book <span class="extraColor">Promotion Success! </span>
                </h2>
                <p class="text-black font-16 fw-500 mp text-center">
                    We have a team of marketing maestros who maximize the marketing channels and make your book the
                    talk of the town. Here is a recipe of how their marketing is cooked to perfection:
                </p>
            </div>
        </div>
        <div class="row justify-content-center ">
            <img src="https://imagedelivery.net/nJwaBs__P2JfMUeYJ4vmjQ/5e1e4871-10fe-42c1-badc-eb7ba4225200/public"
                class="img-fluid" alt="book_writing_cube">
        </div>
    </div>
</section>

<section class="backgery">
    <div class="container-fluid">
        <div class="row justify-content-center align-items-center">
            <div class="col-md-7 text-left">
                <h2 class="font-50 font-50rem fw-900 text-blue fm-30">
                    Making Your <span class="extraColor">Book a Stellar</span> Addition to the Literature World!
                </h2>
                <p class="pt-2 text-black">
                    If you want to watch your work take off and reach new heights, Book Writing Cube may help you do
                    the trick. With extended years of experience in the industry, we know exactly what it takes to
                    get your book noticed and gain maximum exposure. Call us now to take your book to the next
                    level!
                </p>

                <div class="pt-2 pb-3">
                    <a href="javascript:void(Tawk_API.toggle())" class="btn btn-secondary"
                        id="btn7">LET'S
                        DISCUSS</a>
                    <a href="tel:866-600-0036" class="btn btn-secondary2"> 866-600-0036</a>
                </div>
            </div>
            <div class="col-md-1"></div>
            <div class="col-md-4 pr-0 relative animate__fadeInLeft wow">
                <div class="pt-3 pl-0 contact-form relative">
                    <div class="leadforms">
                        <h4 class="pb-3 text-center font-30 fw-900 text-black">
                            Get A Free Quote
                        </h4>
                    </div>
                    <form class="contactform-bottom pl-4 pr-4 pb-4" role="form">
                        <!--<input type="hidden" value="https://www.bookwritingcube.us/book-promotion-services/" id="page_url" name="page_url" />-->
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="">Full Name*</label>
                                <input type="text" id="name" name="name" placeholder="Your name..."
                                    class="form-control" required="">
                            </div>

                            <div class="form-group col-md-12">
                                <label for="">Emai Address *</label>
                                <input type="email" id="email" name="email" placeholder="Type Email Address"
                                    class="form-control" required="">
                            </div>
                            <div class="form-group col-md-12 ">
                                <label for="">Phone *</label>
                                <input type="phone" id="phone" name="phone" placeholder="123-456-7890"
                                    minlength="7" maxlength="15" class="form-control" required=""
                                    onkeypress="return /[0-9]/i.test(event.key)">

                            </div>
                            <div class="form-group col-md-12">
                                <label for="">Message *</label>
                                <textarea type="text" id="message" name="message" placeholder="Type Your Message Here" class="form-control "></textarea>
                            </div>
                        </div>

                        <div class="text-center">
                            <button type="submit" name="saves1" id="butact2"
                                class="btn btn-secondary text-uppercase fw-800  btn-block">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>


<x-footer />
